#include "BOLTApp.h"

#include "db/BOLTdb.h"
#include "ctrl/BOLTUser.h"
#include "ctrl/BOLTChooser.h"
#include "BOLTFrm.h"
#include "ctrl/BOLTControls.h"
#include "../resource/resource.h"

// Create a new application object: this macro will allow wxWindows to create
// the application object during program execution (it's better than using a
// static object for many reasons) and also declares the accessor function
// wxGetApp() which will return the reference of the right type (i.e. BOLTApp and
// not wxApp)

IMPLEMENT_APP(BOLTApp)
IMPLEMENT_DYNAMIC_CLASS(BOLTApp,wxApp)
BEGIN_EVENT_TABLE(BOLTApp,wxApp)
//EVT_KEY_UP(BOLTApp::OnKey)
EVT_CHAR_HOOK(BOLTApp::OnKey)
//EVT_IDLE(wxApp::OnIdle)
END_EVENT_TABLE()
// 'Main program' equivalent: the program execution "starts" here
#include <wx/image.h>


bool BOLTApp::OnInit()
{
	#ifdef __WXDEBUG__
	wxDebugContext::SetDebugMode(TRUE);
	wxDebugContext::SetCheckPrevious(TRUE);
	wxDebugContext::SetCheckpoint();
	#endif

	wxInitAllImageHandlers();
	config = new myConfig(APPNAME,VENDNAME);
//	config = myConfig::Create(APPNAME,VENDNAME);
	myConfig::Set(config);
	wxToolTip::Enable(TRUE);
	wxToolTip::SetDelay(500);
	frame=NULL;
	// create the main application window
	frame = new BOLTFrame("BITE SQL Reports",wxDefaultPosition,wxDefaultSize);
	// and show it (the frames, unlike simple controls, are not shown when
	// created initially)
 //   frame->Show(TRUE);

	// success: wxApp::OnRun() will be called which will enter the main message
	// loop and the application will run. If we returned FALSE here, the
	// application would exit immediately.
//wxHandleFatalExceptions(TRUE);
	return TRUE;
}

int BOLTApp::OnExit()
{ 
	safe_delete(config);
#ifdef __WXDEBUG__
//	wxASSERT_MSG(wxDebugContext::Check()==0,"Memory Corruption Detected ?");
//	wxDebugContext::Dump();
//	wxDebugContext::PrintStatistics(TRUE);
#endif 
	return(0);
}


void BOLTApp::OnKey(wxKeyEvent &event)
{
	if ((frame!=NULL)&&(event.GetKeyCode()==WXK_ESCAPE)&&frame->IsEnabled())
	{
		frame->DispatchForm(ID_CLOSEPAGE,1);
		//TODO - should I skip the event if the page doesn't close ?
		// Home Page, escape to close a pop-up menu
	}
	else { event.Skip(); }
}

void BOLTApp::OnFatalException()
{
	wxLogError("Fatal Exception - You will need to restart the program");
//TODO - try to do some type of memory dump, restart the program, etc
//	wxTrap();
}
